using RimWorld;
using RimWorld.Planet;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.CompilerServices;
using System.Text;
using Verse;

namespace Vanya
{
	public class Vanya_WandererJoin : IncidentWorker
	{
		private const float RelationWithColonistWeight = 20f;

		public override bool TryExecute(IncidentParms parms)
		{
			Map map = (Map)parms.target;
			IntVec3 loc;
			if (!CellFinder.TryFindRandomEdgeCellWith((IntVec3 c) => map.reachability.CanReachColony(c), map, CellFinder.EdgeRoadChance_Neutral, out loc))
			{
				return false;
			}
			PawnKindDef pawnKindDef = new List<PawnKindDef>
			{
				PawnKindDefOf.Villager
			}.RandomElement<PawnKindDef>();
            Faction faction = Find.FactionManager.FirstFactionOfDef(FactionDefOf.Spacer);
            PawnGenerationRequest request = new PawnGenerationRequest(pawnKindDef, Faction.OfPlayer, PawnGenerationContext.NonPlayer, -1, false, false, false, false, true, false, 20f, false, true, true, false, false, null, null, null, null, null, null);
			Pawn pawn = PawnGenerator.GeneratePawn(request);

            string text = this.CreateRefugeeText(pawn);
            /*string text = "Vanya_WandererJoin".Translate(new object[]
			{
				pawnKindDef.label,
				pawn.story.Title.ToLower(),
                pawn.ageTracker.AgeBiologicalYears
            });
			text = text.AdjustedFor(pawn);
			PawnRelationUtility.TryAppendRelationsWithColonistsInfo(ref text, pawn);*/

            DiaNode diaNode = new DiaNode(text);
            DiaOption diaOption = new DiaOption("Vanya_WandererJoin_Accept".Translate());
            diaOption.action = delegate
            {
                GenSpawn.Spawn(pawn, loc, map);
                pawn.SetFaction(Faction.OfPlayer, null);
                Find.CameraDriver.JumpToVisibleMapLoc(loc);
            };
            diaOption.resolveTree = true;
            diaNode.options.Add(diaOption);
            DiaOption diaOption2 = new DiaOption("Vanya_WandererJoin_Reject".Translate());
            diaOption2.action = delegate
            {
                Find.WorldPawns.PassToWorld(pawn, PawnDiscardDecideMode.Decide);
            };
            diaOption2.resolveTree = true;
            diaNode.options.Add(diaOption2);
            Find.WindowStack.Add(new Dialog_NodeTree(diaNode, true, true));
            return true;
		}



        private string CreateRefugeeText(Pawn pawn)
        {
            StringBuilder stringBuilder = new StringBuilder("Vanya_WandererJoin".Translate(new object[]
            {
                pawn.Name.ToStringFull,
                pawn.story.Title.ToLower(),
                pawn.ageTracker.AgeBiologicalYears,
                pawn.story.bodyType,
                pawn.story.crownType,
                pawn.story.hairDef.label
            }).AdjustedFor(pawn));
            string value = "";
            PawnRelationUtility.TryAppendRelationsWithColonistsInfo(ref value, pawn);
            stringBuilder.Append(value);
            stringBuilder.AppendLine();
            stringBuilder.AppendLine();
            stringBuilder.AppendLine();
            this.AppendStats(stringBuilder, pawn);
            return stringBuilder.ToString();
        }

        private void AppendStats(StringBuilder sb, Pawn pawn)
        {
            this.AppendDisabledWorkTags(sb, pawn.story.CombinedDisabledWorkTags);
            sb.AppendLine();
            sb.AppendLine();
            this.AppendTraits(sb, pawn.story.traits.allTraits);
            sb.AppendLine();
            sb.AppendLine();
            this.AppendPassions(sb, pawn.skills.skills);
        }

        private void AppendDisabledWorkTags(StringBuilder sb, WorkTags disabledWorkTags)
        {
            sb.Append(this.CreateTitle("IncapableOf".Translate()));
            sb.AppendLine();
            if (disabledWorkTags == WorkTags.None)
            {
                sb.Append("(" + "NoneLower".Translate() + ")");
                return;
            }
            int num = 0;
            bool flag = true;
            foreach (WorkTags workTags in Enum.GetValues(typeof(WorkTags)))
            {
                if (workTags != WorkTags.None && (disabledWorkTags & workTags) == workTags)
                {
                    if (num > 0)
                    {
                        sb.Append(", ");
                    }
                    if (!flag)
                    {
                        sb.Append(workTags.LabelTranslated().ToLower());
                    }
                    else
                    {
                        sb.Append(workTags.LabelTranslated());
                    }
                    num++;
                    flag = false;
                }
            }
        }

        private void AppendTraits(StringBuilder sb, List<Trait> traits)
        {
            sb.Append(this.CreateTitle("Traits".Translate()));
            foreach (Trait current in traits)
            {
                sb.AppendLine();
                sb.Append(current.LabelCap);
            }
        }

        private void AppendPassions(StringBuilder sb, List<SkillRecord> skills)
        {
            sb.Append(this.CreateTitle("Vanya_Passion".Translate()));
            sb.AppendLine();
            if (skills.Count == 0)
            {
                sb.Append("(" + "NoneLower".Translate() + ")");
                return;
            }
            int num = 0;
            foreach (SkillRecord current in skills)
            {
                if (current.passion > Passion.None)
                {
                    if (num > 0)
                    {
                        sb.Append(", ");
                    }
                    sb.Append(current.def.skillLabel + ((current.passion == Passion.Major) ? "(" + "Vanya_PassionMajor".Translate() + ")": "(" + "Vanya_PassionMinor".Translate() + ")" ));
                    num++;
                }
            }
        }

        private string CreateTitle(string title)
        {
            return string.Concat(new object[]
            {
                "<b><size=",
                18,
                ">",
                title,
                "</size></b>"
            });
        }
    }
}
